osp_detect() {
  case $1 in
    *.conf) SPACES=$(sed -n "/^output_session_processing {/,/^}/ {/^ *music {/p}" $1 | sed -r "s/( *).*/\1/")
            EFFECTS=$(sed -n "/^output_session_processing {/,/^}/ {/^$SPACES\music {/,/^$SPACES}/p}" $1 | grep -E "^$SPACES +[A-Za-z]+" | sed -r "s/( *.*) .*/\1/g")
            for EFFECT in ${EFFECTS}; do
              SPACES=$(sed -n "/^effects {/,/^}/ {/^ *$EFFECT {/p}" $1 | sed -r "s/( *).*/\1/")
              [ "$EFFECT" != "atmos" ] && sed -i "/^effects {/,/^}/ {/^$SPACES$EFFECT {/,/^$SPACES}/ s/^/#/g}" $1
            done;;
     *.xml) EFFECTS=$(sed -n "/^ *<postprocess>$/,/^ *<\/postprocess>$/ {/^ *<stream type=\"music\">$/,/^ *<\/stream>$/ {/<stream type=\"music\">/d; /<\/stream>/d; s/<apply effect=\"//g; s/\"\/>//g; p}}" $1)
            for EFFECT in ${EFFECTS}; do
              [ "$EFFECT" != "atmos" ] && sed -ri "s/^( *)<apply effect=\"$EFFECT\"\/>/\1<\!--<apply effect=\"$EFFECT\"\/>-->/" $1
            done;;
  esac
}

# Tell user aml is needed if applicable
if $MAGISK && ! $SYSOVERRIDE; then
  if $BOOTMODE; then LOC="/sbin/.core/img/*/system $MOUNTPATH/*/system"; else LOC="$MOUNTPATH/*/system"; fi
  FILES=$(find $LOC -type f -name "*audio_effects*.conf" -o -name "*audio_effects*.xml")
  if [ ! -z "$FILES" ] && [ ! "$(echo $FILES | grep '/aml/')" ]; then
    ui_print " "
    ui_print "   ! Conflicting audio mod found!"
    ui_print "   ! You will need to install !"
    ui_print "   ! Audio Modification Library !"
    sleep 3
  fi
fi

rm -rf /data/app/com.atmos*
rm -rf /data/app/com.dolby*

ui_print "   Patching existing audio_effects files..."
  for OFILE in ${CFGS}; do
    FILE="$UNITY$(echo $OFILE | sed "s|^/vendor|/system/vendor|g")"
    cp_ch_nb $ORIGDIR$OFILE $FILE 0644 false
    osp_detect $FILE
    case $FILE in
      *.conf) sed -i "s/^effects {/effects {\n  dsplus { #$MODID\n    library dsplus\n    uuid 9d4921da-8225-4f29-aefa-39537a04bcaa\n  } #$MODID/g" $FILE
              sed -i "s/^libraries {/libraries {\n  dsplus { #$MODID\n    path $LIBPATCH\/lib\/soundfx\/libdseffect.so\n  } #$MODID/g" $FILE;;
      *.xml) sed -i "/<libraries>/ a\        <library name=\"dsplus\" path=\"libdseffect.so\"\/><!--$MODID-->" $FILE
             sed -i "/<effects>/ a\        <effect name=\"dsplus\" library=\"dsplus\" uuid=\"9d4921da-8225-4f29-aefa-39537a04bcaa\"\/><!--$MODID-->" $FILE;;
             esac
             done