# AnyKernel3 Ramdisk Mod Script
# osm0sis @ xda-developers

## AnyKernel setup
# begin properties
properties() { '
kernel.string=Panda Kernel by Pzqqt
do.devicecheck=1
do.modules=0
do.systemless=1
do.cleanup=1
do.cleanuponabort=0
device.name1=whyred
device.name2=
device.name3=
device.name4=
device.name5=
supported.versions=
supported.patchlevels=
'; } # end properties

# shell variables
block=/dev/block/bootdevice/by-name/boot;
is_slot_device=0;
ramdisk_compression=auto;


## AnyKernel methods (DO NOT CHANGE)
# import patching functions/variables - see for reference
. tools/ak3-core.sh;


## AnyKernel install
dump_boot;

############################## CUSTOM BY PANDA KERNEL ##############################

# Set Android version flag
api=`file_getprop /system/build.prop ro.build.version.release`
if [ -n "$api" ]; then
    patch_cmdline "androidboot.version" "androidboot.version=${api}"
else
    patch_cmdline "androidboot.version" ""
fi

rm -rf /data/adb/modules/whyred-battery-chargefull-fix
rm -rf /data/adb/modules/pure_spectrum

chmod 0755 ${home}/tools/bspatch
chmod 0755 ${home}/tools/7za

sha1() {
  sha1sum $1 | awk '{print $1}';
}

# apply_patch <src_path> <dst_sha1> <src_sha1> <patch>
apply_patch() {
  local file_sha1=$(sha1 "${1}")
  [ "$file_sha1" == "$2" ] && return 0;
  [ "$file_sha1" == "$3" ] && ${home}/tools/bspatch "$1" "$1" "$4";
  [ $(sha1 "${1}") == "$2" ] || abort "! Failed to patch $1!"
}

is_oc=$(cat /tmp/aroma/is_oc.prop | cut -d '=' -f2)         # Enable: 1; Disable:2
uv_level=$(cat /tmp/aroma/uv_level.prop | cut -d '=' -f2)   # No UV: 1; 40mv: 2; 80mv 3
is_fixcam=$(cat /tmp/aroma/is_fixcam.prop | cut -d '=' -f2) # New blobs: 1; Old blobs: 2

[ "$is_oc" == "1" ] && flag_1="2" || flag_1="1"
[ -n "$uv_level" ] && flag_2="$uv_level" || flag_2="1"
dts_img=${flag_1}${flag_2}.dtb

ui_print "- Unpacking files..."
${home}/tools/7za e ${home}/dtbs/dtbs.7z -o${home}/dtbs || :
[ -f ${home}/dtbs/${dts_img} ] || abort "! Failed to extract dtbs!"
${home}/tools/7za e ${home}/Image.7z -o${home} || :
[ -f ${home}/Image ] || abort "! Failed to extract Image!"

case "${flag_2}${is_fixcam}" in
    "12" | "22") [ $(sha1 "${home}/Image") == "98a91f83b1476faaf1e66517480abbb18118e1b5" ] || abort "! Image file is corrupted";;
    *) {
        ui_print "- Patching Image file..."
        case "${flag_2}${is_fixcam}" in
            "32")        apply_patch ${home}/Image "529a3e0ff02d1d8fe214a0f884905f8edaa655cc" "98a91f83b1476faaf1e66517480abbb18118e1b5" ${home}/80uv.p;;
            "11" | "21") apply_patch ${home}/Image "1f9dbb8a4ce8e9031971c6da4a410220dbcac3a5" "98a91f83b1476faaf1e66517480abbb18118e1b5" ${home}/campatch.p;;
            "31")        apply_patch ${home}/Image "64f1cf1e7431a06c9fe8dbf75731d38ec21d23e6" "98a91f83b1476faaf1e66517480abbb18118e1b5" ${home}/80uv_campatch.p;;
            *)           abort "! Unable to parse Aroma flags!";;
        esac
    };;
esac

ui_print "- Generating Image.gz-dtb..."
cat ${home}/Image | gzip -f > ${home}/Image.gz
[ -f ${home}/Image.gz ] || abort "! Failed to compress Image!"
cat ${home}/Image.gz ${home}/dtbs/${dts_img} > ${home}/Image.gz-dtb
rm -f ${home}/Image.7z ${home}/Image ${home}/Image.gz

ui_print "- Starting install Image.gz-dtb..."
############################## CUSTOM END ##############################

write_boot;
## end install

